/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

import frc.emul.psg.IPsgCore;
import frc.emul.psg.dev.PsgRecord;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsgPlaybackThread
extends Thread {
    private final List<PsgRecord> records;
    private final IPsgCore psg;
    private int curIdx;
    private final double speed;

    public PsgPlaybackThread(double d, List<PsgRecord> list, IPsgCore iPsgCore) {
        this.setName("PsgPlaybackThread");
        this.records = list;
        this.psg = iPsgCore;
        this.speed = d;
    }

    @Override
    public void run() {
        try {
            if (this.records.size() > 0) {
                this.play();
            }
        }
        finally {
            this.playbackCompleted();
        }
    }

    private void play() {
        long l = this.records.get(0).getTime();
        while (this.curIdx < this.records.size()) {
            PsgRecord psgRecord = this.records.get(this.curIdx++);
            long l2 = psgRecord.getTime();
            long l3 = (long)((double)(l2 - l) / this.speed);
            while (this.isPaused()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (l3 >= 1000000L) {
                try {
                    Thread.sleep(l3 / 1000000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            l = l2;
            this.psg.writeRegister(psgRecord.getReg(), psgRecord.getData());
        }
    }

    public void playbackCompleted() {
    }

    public boolean isPaused() {
        return false;
    }
}

